import {
    View,
    Text,
    TouchableOpacity,
    FlatList,
    Pressable,
} from 'react-native';
import React, { useState, useEffect } from 'react';
import MenuNavigation from '../Utilities/CustomHeader/MenuNavigation';
import { ProfileStyles } from '../Profile/ProfileStyle';
import Checkbox from 'expo-checkbox';
import { cartStyle } from './shoppingCartStyle';
import DeleteIcon from '../../assets/svgs/my wishlist/delete icon.svg';
import dpr from '../Utilities/CustomStyleAttribute/dpr';
import { useDispatch, useSelector } from 'react-redux';
import useAuth from '../../hooks/useAuth';
import {
    deleteGroupItemsFromCart,
    getCartProduct,
} from '../../redux/slices/cart/getCartProducts';
import SellerGroup from './SellerGroup';
import { restructureData } from './cartCommonFunctions';
import { confirmEmailStyles } from '../../components/Authentication/ConfirmEmail/ConfirmEmailStyle';
import CustomSpinner from '../Utilities/CustomSpinner/CustomSpinner';
import { postSelectProduct } from '../../redux/slices/cart/selectProduct/selectProduct';
import { deleteGroupItems } from '../../redux/slices/cart/deleteCartItem/deleteGroupItems';
import { storeItemInCart } from '../../redux/slices/cart/storeItemInCart';
import { decrementQtyFromCart } from '../../redux/slices/cart/decrementQtyFromCart';
import { resetCoupon } from '../../redux/slices/cart/coupon/applyCoupon';
import { storeSelectedItems } from './utils/storeSelectedItems';
import EmptyContent from '../Utilities/EmptyContent/EmptyContent';
import NoItem from '../../assets/svgs/empty content/noWishlist.svg';
import useCustomToast from '../../hooks/useCustomToast';
import useProcessPrice from '../../hooks/useProcessPrice';
import { useIsFocused } from '@react-navigation/native';
import { getPreferences } from '../../redux/slices/preferences/getPreferences';
import { BASE_API_URL_STG } from '@env';
import useLangTranslation from '../../hooks/useLangTranslation';
import usePreferences from '../../hooks/usePreferences';
import useGuestUser from '../../hooks/useGuestUser';
import CustomSVG from '../../src/components/CustomSVG/CustomSVG';

const selectURL = `${BASE_API_URL_STG}/user/cart/selected-store`;
const storeItemInCartUrl = `${BASE_API_URL_STG}/user/cart/store`;
const decrementUrl = `${BASE_API_URL_STG}/user/cart/reduce-qty`;

const Cart = (props) => {
    const { trans } = useLangTranslation();
    const dispatch = useDispatch();
    const isGuest = useGuestUser();
    const { preference: { guest_order } = {} } = usePreferences();
    const showToast = useCustomToast();
    const { access_token } = useAuth();
    const processPrice = useProcessPrice();
    const {
        cart_Data: { cartData, selectedCarts, vendors } = {},
        cartLoading,
    } = useSelector((state) => state.cartProductSlice);
    const { cartLoading: storeItemLoading } = useSelector(
        (state) => state.storeItemInCartSlice
    );
    const [data, setData] = useState([]);
    const [isCheckAll, setIsCheckAll] = useState(false);
    const [isGroupCheck, setIsGroupCheck] = useState([]);
    const [isCheck, setIsCheck] = useState([]);
    const [priceData, setPriceData] = useState({});
    const isFocus = useIsFocused();

    useEffect(() => {
        let isMounted = true;
        if (isMounted && isFocus) {
            const CARTURL = `${BASE_API_URL_STG}/user/carts`;
            dispatch(getCartProduct({ access_token, CARTURL }));
        }
        return () => {
            isMounted = false;
        };
    }, [isFocus]);

    useEffect(() => {
        if (isCheck?.length > 0) {
            const { priceData } = storeSelectedItems(isCheck, data);
            setPriceData(priceData);
        } else {
            setPriceData({});
        }
    }, [isCheck, data]);

    useEffect(() => {
        let data = [];
        if (cartData?.length > 0) {
            data = restructureData(cartData, vendors);
            setData(data);
        } else {
            setData(data);
        }

        // set single checkbox
        let selectedCartsConvertToNum =
            selectedCarts?.map((str) => Number(str)) || [];

        let checkedItem = selectedCartsConvertToNum
            ?.filter((item) => {
                return cartData?.find(
                    (cartItem) =>
                        cartItem?.id == item &&
                        cartItem?.inventoryEnable == true &&
                        cartItem?.availability == 1
                );
            })
            .map((item) => item);
        selectedItemStoreFunction(checkedItem);
        setIsCheck(checkedItem);

        //set group checkbox
        let updateGroupCheck = [];
        if (data?.length > 0) {
            let groupCheckValues = [];
            for (let item of data) {
                if (checkedItem && item) {
                    let x = selectGroup(
                        checkedItem,
                        item,
                        updateGroupCheck,
                        groupCheckValues
                    );
                    groupCheckValues = x;
                    updateGroupCheck = [...updateGroupCheck, ...x].filter(
                        (v, i, a) => a.indexOf(v) === i
                    );
                }
            }
            setIsGroupCheck(updateGroupCheck);
            // select all
            if (updateGroupCheck?.length == data?.length) {
                setIsCheckAll(true);
            } else {
                setIsCheckAll(false);
            }
        }
    }, [cartData, selectedCarts]);

    const handleCheckAll = (e) => {
        let selectAll;
        setIsCheckAll(!isCheckAll);
        if (e) {
            //select group check
            setIsGroupCheck(
                data?.map((li) => {
                    return Number(li.vendor_id);
                })
            );
            // select single check
            let selectAllCheckbox = data?.map((arr) =>
                arr.items.map((a) => a.id)
            );
            selectAll = selectAllCheckbox
                .join()
                .split(',')
                .map((str) => Number(str));
            setIsCheck(selectAll);
            selectedItemStoreFunction(selectAll);
        } else {
            setIsGroupCheck([]);
            setIsCheck([]);
        }
    };

    const handleGroupCheck = (e, id) => {
        let groups = [];
        if (isGroupCheck.indexOf(id) == -1) {
            groups = [...isGroupCheck, id];
            setIsGroupCheck(groups);
        }
        let groupCheck;
        if (!e) {
            setIsGroupCheck(isGroupCheck.filter((item) => item !== id));
            let selectWhichCheckboxUncheck = data
                .find((arr) => arr.vendor_id == id)
                .items.map((a) => a.id);
            groupCheck = isCheck.filter(
                (item) => !selectWhichCheckboxUncheck.includes(item)
            );
            setIsCheck(groupCheck);
        } else {
            let singleCheck = data
                .find((arr) => arr.vendor_id == id)
                .items.map((a) => a.id);
            groupCheck = [...isCheck, ...singleCheck].filter(
                (v, i, a) => a.indexOf(v) === i
            );
            setIsCheck(groupCheck);
        }
        selectedItemStoreFunction(groupCheck);

        if (groups.length == data.length) {
            setIsCheckAll(true);
        } else {
            setIsCheckAll(false);
        }
    };

    const handleCheck = (e, id, vendor_id) => {
        //single select
        let allCheck;
        if (!e) {
            allCheck = isCheck.filter((itemId) => itemId != id);
            setIsCheck(allCheck);
        } else {
            allCheck = [...isCheck, id];
            setIsCheck(allCheck);
        }
        selectedItemStoreFunction(allCheck);
        // group select
        let uncheckGroup = data.find((item) => item.vendor_id == vendor_id);
        let updateGroupCheck = [];
        if (uncheckGroup && allCheck) {
            updateGroupCheck = selectGroup(
                allCheck,
                uncheckGroup,
                updateGroupCheck,
                isGroupCheck
            );
            setIsGroupCheck(updateGroupCheck);
        }

        if (updateGroupCheck?.length == data?.length) {
            setIsCheckAll(true);
        } else {
            setIsCheckAll(false);
        }
    };

    const selectedItemStoreFunction = (allCheck) => {
        const data = {
            id: `[${allCheck}]`,
        };
        dispatch(
            postSelectProduct({
                access_token,
                selectURL,
                method: 'POST',
                data,
            })
        );
        dispatch(resetCoupon());
    };

    const selectGroup = (
        allCheck,
        uncheckGroup,
        updateGroupCheck,
        groupCheckValues
    ) => {
        let allCheckTrue = true;
        for (let item of uncheckGroup.items) {
            if (allCheck.indexOf(item.id) == -1) {
                allCheckTrue = false;
            }
        }
        if (allCheckTrue) {
            updateGroupCheck = [
                ...groupCheckValues,
                uncheckGroup.vendor_id,
            ].filter((v, i, a) => a.indexOf(v) === i);
            updateGroupCheck = updateGroupCheck.map((str) => Number(str));
        } else {
            updateGroupCheck = groupCheckValues.filter(
                (item) => item != uncheckGroup.vendor_id
            );
        }
        return updateGroupCheck;
    };

    const handleDeleteAll = () => {
        const deleteGroupURL = `${BASE_API_URL_STG}/user/cart/selected-delete`;
        const data = {
            id: `[${isCheck}]`,
        };
        dispatch(deleteGroupItemsFromCart(isCheck));
        dispatch(
            deleteGroupItems({
                access_token,
                deleteGroupURL,
                method: 'POST',
                data,
            })
        );
    };

    const handleIncrement = async (id) => {
        const updateData = [];
        for (let group of data) {
            const updateGroup = [];
            for (let item of group.items) {
                if (item.id == id) {
                    const cartData = {
                        code: item.parent_code ? item.parent_code : item.code,
                        variation_id: item.variation_id,
                        qty: 1,
                    };
                    const res = await dispatch(
                        storeItemInCart({
                            access_token,
                            storeItemInCartUrl,
                            cartData,
                        })
                    );
                    const { status } = res?.payload || {};
                    if (status?.code == 200) {
                        updateGroup.push({
                            ...item,
                            quantity: Number(item.quantity) + 1,
                        });
                    } else {
                        updateGroup.push(item);
                        showToast({
                            text1:
                                trans(status?.message) ||
                                trans('Something went wrong'),
                            type: 'common',
                            position: 'bottom',
                            props: { variant: 'error' },
                        });
                    }
                } else {
                    updateGroup.push(item);
                }
            }
            updateData.push({
                ...group,
                items: updateGroup,
            });
        }
        setData(updateData);
    };

    const handleDecrement = (index) => {
        const updateData = data?.map((group) => {
            return {
                ...group,
                items: group.items.map((item) => {
                    if (item.index == index) {
                        const data = {
                            cartIndex: index,
                        };
                        dispatch(
                            decrementQtyFromCart({
                                access_token,
                                decrementUrl,
                                method: 'POST',
                                data,
                            })
                        );
                        return {
                            ...item,
                            quantity: Number(item.quantity) - 1,
                        };
                    } else {
                        return item;
                    }
                }),
            };
        });
        setData(updateData);
    };

    const handleProceedToCheckout = () => {
        props.navigation.navigate(
            isGuest ? 'guest billing info' : 'billing info'
        );
        setIsCheck([]);
        setIsGroupCheck([]);
        setIsCheckAll(false);
    };

    const handleRefresh = () => {
        const CARTURL = `${BASE_API_URL_STG}/user/carts`;
        dispatch(getCartProduct({ access_token, CARTURL }));
        dispatch(getPreferences());
    };
    let isAllDisable = false;
    for (let item of data) {
        for (let i of item?.items) {
            if (i.inventoryEnable == false || i.availability == 0) {
                isAllDisable = true;
            }
        }
    }
    return (
        <>
            {(cartLoading || storeItemLoading) && <InOnScreenLoader />}
            <MenuNavigation
                navigationProps={props.navigation}
                routeName={trans('my cart')}
            />
             <View style={ProfileStyles.hrLine} />
            <View style={cartStyle.container}>
                {(cartData?.length == 0 || !cartData) && (
                    <FlatList
                        ListHeaderComponent={() => (
                            <EmptyContent
                                Icon={NoItem}
                                text={trans('No Items Saved For Order')}
                            />
                        )}
                        onRefresh={handleRefresh}
                        refreshing={false}
                    />
                )}
                {cartData?.length > 0 && (
                    <View
                        style={cartStyle.selectAllCont(isCheckAll)}
                    >
                        <View style={[cartStyle.deleteAllCont, cartStyle.allItem]} >
                            <TouchableOpacity onPress={() => handleCheckAll(!isCheckAll)} hitSlop={6}>
                                <Checkbox
                                    disabled={isAllDisable}
                                    value={isCheckAll}
                                    onValueChange={handleCheckAll}
                                    color={isCheckAll ? '#2C2C2C' : '#DFDFDF'}
                                    style={cartStyle.checkBoxSize}
                                />
                            </TouchableOpacity>
                            <Text
                                style={[
                                    cartStyle.deleteText,
                                    cartStyle.color(isCheckAll)
                                ]}
                                numberOfLines={1}
                            >
                                {trans('Select All ({{x}} Items)', {x: cartData?.length || 0,})}
                            </Text>
                        </View>
                        <TouchableOpacity
                            style={[cartStyle.deleteAllCont, cartStyle.allDlt]}
                            onPress={handleDeleteAll}
                        >
                            <Text
                                style={[
                                    cartStyle.deleteText,
                                    cartStyle.color(isCheckAll)
                                ]}
                                numberOfLines={1}
                            >
                                {trans('Delete Selected Items')}
                            </Text>
                            <CustomSVG svgIcon={DeleteIcon}
                                height={dpr(14)}
                                width={dpr(14)}
                                fill={isCheckAll ? '#2C2C2C' : '#898989'}
                            />
                        </TouchableOpacity>
                    </View>
                )}
                <FlatList
                    data={data}
                    renderItem={({ item }) => (
                        <SellerGroup
                            item={item}
                            isGroupCheck={isGroupCheck}
                            handleGroupCheck={handleGroupCheck}
                            isCheck={isCheck}
                            handleCheck={handleCheck}
                            handleIncrement={handleIncrement}
                            handleDecrement={handleDecrement}
                        />
                    )}
                    keyExtractor={(_, i) => 'key' + i}
                    showsVerticalScrollIndicator={false}
                    onRefresh={handleRefresh}
                    refreshing={false}
                />
            </View>
            <View style={cartStyle.checkoutCont}>
                <View>
                    <Text style={cartStyle.totalPriceText}>
                        {trans('Total Price')}
                    </Text>
                    <Text
                        style={[
                            cartStyle.totalPriceText,
                            cartStyle.totalPriceTextSize
                        ]}
                    >
                        {processPrice(priceData.totalPrice || 0)}
                    </Text>
                </View>
                <Pressable
                    disabled={isCheck.length > 0 ? false : true}
                    style={[
                        cartStyle.proceedBtn,
                        cartStyle.bg(priceData.totalPrice)
                    ]}
                    onPress={handleProceedToCheckout}
                >
                    <Text style={cartStyle.proceedText}>
                        {trans('Proceed to Checkout')}
                    </Text>
                </Pressable>
            </View>
        </>
    );
};

export default Cart;

export const InOnScreenLoader = () => (
    <View style={confirmEmailStyles.loading}>
        <CustomSpinner
            filePath={require('../../assets/lottie/loader.json')}
            size={{
                width: dpr(80),
                height: dpr(70),
            }}
        />
    </View>
);
